# 🏨 cPanel-ზე ინსტალაციის ინსტრუქცია

## 📋 საჭირო ფაილები cPanel-ისთვის:

- `api.php` - PHP Backend API
- `config.php` - მონაცემთა ბაზის კონფიგურაცია
- `hotel-booking.html` - დაჯავშნის ფორმა
- `admin-dashboard.html` - ადმინის პანელი
- `database.sql` - MySQL ბაზის სტრუქტურა
- `.htaccess` - Apache კონფიგურაცია

## 🚀 ნაბიჯ-ნაბიჯ ინსტალაცია

### ნაბიჯი 1: MySQL მონაცემთა ბაზის შექმნა

1. **შედით cPanel-ში**
   - გადადით თქვენს cPanel-ის მისამართზე (მაგ: https://yourdomain.com/cpanel)
   - შეიყვანეთ username და password

2. **მონაცემთა ბაზის შექმნა**
   - იპოვეთ "MySQL Databases" ან "MySQL Database Wizard"
   - დააჭირეთ "MySQL Database Wizard"
   
   **Step 1 - Create Database:**
   ```
   Database Name: hotel_booking
   ```
   დააჭირეთ "Next Step"

   **Step 2 - Create User:**
   ```
   Username: hotel_user
   Password: [შექმენით ძლიერი პაროლი]
   ```
   დააჭირეთ "Create User"

   **Step 3 - Add User to Database:**
   ```
   ✅ ALL PRIVILEGES (ყველა უფლება)
   ```
   დააჭირეთ "Next Step"

3. **ჩაიწერეთ შემდეგი მონაცემები:**
   ```
   Database Name: username_hotel_booking  (username თქვენი cPanel username-ია)
   Database User: username_hotel_user
   Password: [თქვენი შექმნილი პაროლი]
   Host: localhost
   ```

### ნაბიჯი 2: ცხრილის შექმნა phpMyAdmin-ში

1. **გახსენით phpMyAdmin**
   - cPanel-ში იპოვეთ "phpMyAdmin"
   - დააჭირეთ მას

2. **აირჩიეთ თქვენი ბაზა**
   - მარცხენა მხარეს აირჩიეთ `username_hotel_booking`

3. **SQL Tab-ზე გადასვლა**
   - ზედა მენიუში დააჭირეთ "SQL"

4. **SQL კოდის შეყვანა**
   - გახსენით `database.sql` ფაილი
   - დააკოპირეთ მთელი კოდი
   - ჩასვით SQL ველში
   - დააჭირეთ "Go" ღილაკს

5. **შეამოწმეთ**
   - უნდა გამოჩნდეს "bookings" ცხრილი მარცხენა სიაში

### ნაბიჯი 3: ფაილების ატვირთვა

1. **გახსენით File Manager**
   - cPanel-ში იპოვეთ "File Manager"
   - გადადით `public_html` საქაღალდეში

2. **შექმენით საქაღალდე (არააუცილებელი)**
   ```
   public_html/hotel/
   ```
   ან უბრალოდ `public_html`-ში ატვირთეთ

3. **ატვირთეთ ფაილები**
   - დააჭირეთ "Upload" ღილაკს
   - აირჩიეთ და ატვირთეთ ყველა ფაილი:
     - `api.php`
     - `config.php`
     - `hotel-booking.html`
     - `admin-dashboard.html`
     - `.htaccess`

### ნაბიჯი 4: config.php ფაილის რედაქტირება

1. **File Manager-ში იპოვეთ config.php**
2. **დააჭირეთ მარჯვენა ღილაკს → Edit**
3. **შეცვალეთ მონაცემები:**

```php
<?php
define('DB_HOST', 'localhost');
define('DB_NAME', 'username_hotel_booking');  // თქვენი database name
define('DB_USER', 'username_hotel_user');     // თქვენი database user
define('DB_PASS', 'your_actual_password');    // თქვენი password
```

4. **დააჭირეთ "Save Changes"**

### ნაბიჯი 5: api.php ფაილის რედაქტირება

1. **File Manager-ში იპოვეთ api.php**
2. **დააჭირეთ მარჯვენა ღილაკს → Edit**
3. **ხაზები 11-14, შეცვალეთ:**

```php
$host = 'localhost';
$dbname = 'username_hotel_booking';   // თქვენი database
$username = 'username_hotel_user';    // თქვენი user
$password = 'your_actual_password';   // თქვენი password
```

4. **დააჭირეთ "Save Changes"**

### ნაბიჯი 6: ფაილების უფლებების დაყენება (Permissions)

1. **File Manager-ში:**
   - `api.php` → Right Click → Permissions → `644`
   - `config.php` → Right Click → Permissions → `644`
   - `.htaccess` → Right Click → Permissions → `644`
   - HTML ფაილები → `644`

### ნაბიჯი 7: ტესტირება

1. **გახსენით ბრაუზერში:**
   ```
   https://yourdomain.com/hotel-booking.html
   ```
   ან
   ```
   https://yourdomain.com/hotel/hotel-booking.html
   ```

2. **შეავსეთ ფორმა და გააგზავნეთ**

3. **შეამოწმეთ ადმინ პანელი:**
   ```
   https://yourdomain.com/admin-dashboard.html
   ```

4. **თუ ყველაფერი მუშაობს - გილოცავთ! 🎉**

## 🔧 შეცდომების გამოსწორება

### შეცდომა: "Database connection failed"

**გადაწყვეტა:**
1. შეამოწმეთ `config.php` და `api.php` ფაილებში მონაცემები
2. დარწმუნდით რომ database user-ს აქვს ყველა უფლება
3. phpMyAdmin-ში სცადეთ დაკავშირება იმავე მონაცემებით

### შეცდომა: "404 Not Found"

**გადაწყვეტა:**
1. დარწმუნდით რომ ფაილები სწორ საქაღალდეშია
2. შეამოწმეთ `.htaccess` ფაილი
3. დარწმუნდით რომ URL სწორია

### შეცდომა: "500 Internal Server Error"

**გადაწყვეტა:**
1. შეამოწმეთ PHP სინტაქსი `api.php`-ში
2. File Manager → Error Logs → გახსენით error_log
3. შეასწორეთ შეცდომები რაც ლოგში ჩანს

### ფორმა არ აგზავნის მონაცემებს

**გადაწყვეტა:**
1. ბრაუზერში გახსენით Developer Tools (F12)
2. Console Tab → ნახეთ JavaScript errors
3. Network Tab → ნახეთ API request-ები
4. დარწმუნდით რომ `api.php` პასუხობს

## 📱 Admin Panel-ის დაცვა

მნიშვნელოვანია რომ ადმინ პანელი დაცული იყოს!

### ვარიანტი 1: Password Protection (.htpasswd)

1. **cPanel → Directory Privacy**
2. აირჩიეთ საქაღალდე სადაც არის `admin-dashboard.html`
3. ჩართეთ Password Protection
4. შექმენით Username და Password

### ვარიანტი 2: IP Restriction

`.htaccess` ფაილში დაამატეთ:

```apache
<Files "admin-dashboard.html">
    Order deny,allow
    Deny from all
    Allow from 1.2.3.4  # თქვენი IP მისამართი
</Files>
```

### ვარიანტი 3: გადაარქვით ფაილს

```
admin-dashboard.html → admin-f8d9sk2j.html
```

## 🎯 საბოლოო სტრუქტურა

```
public_html/
│
├── hotel-booking.html       (მომხმარებლის ფორმა)
├── admin-dashboard.html     (ადმინის პანელი)
├── api.php                  (Backend API)
├── config.php               (Database config)
├── .htaccess               (Apache config)
└── [სხვა თქვენი ფაილები]
```

## ✅ შემოწმების Checklist

- [ ] MySQL ბაზა შექმნილია
- [ ] bookings ცხრილი შექმნილია
- [ ] ყველა ფაილი ატვირთულია
- [ ] config.php კონფიგურირებულია
- [ ] api.php კონფიგურირებულია
- [ ] ფაილების უფლებები სწორია (644)
- [ ] ფორმა მუშაობს და აგზავნის მონაცემებს
- [ ] ადმინ პანელში ჩანს დაჯავშნები
- [ ] ადმინ პანელი დაცულია

## 🆘 დამატებითი დახმარება

თუ რამე არ მუშაობს:

1. **შეამოწმეთ PHP ვერსია**
   - cPanel → Select PHP Version
   - უნდა იყოს PHP 7.4+ ან 8.x

2. **ჩართეთ Error Display (დროებით)**
   
   `api.php` ფაილის დასაწყისში დაამატეთ:
   ```php
   <?php
   ini_set('display_errors', 1);
   error_reporting(E_ALL);
   ```

3. **დაუკავშირდით Hosting Support-ს**
   - უთხარით რომ გჭირდებათ PHP და MySQL access
   - მოითხოვეთ `.htaccess` support

## 🎉 წარმატების შემთხვევაში

თქვენი სისტემა მუშაობს!
- Frontend: `https://yourdomain.com/hotel-booking.html`
- Admin: `https://yourdomain.com/admin-dashboard.html`

ინვოისები ავტომატურად გენერირდება და მონაცემები ინახება MySQL-ში! 🚀
